package ParserIO;
@ISA = qw(Exporter);
use English;
require Exporter;
@EXPORT = qw(inputfile nextchar eatchar mark rollback EoF
	     error PrintTrailer enter leave gettextfrom);

#----------------------------------------
# I/O routines
#----------------------------------------

sub inputfile {
# Assumes the whole grammar on the <> filehandle...
    undef $INPUT_RECORD_SEPARATOR;
    for $file (@main::ARGV) {
	open(FILE, $file) || die "Unable to open $file\n";
	$buffer .= <FILE>;
	close FILE;
    }
    @buffer = split(//, $buffer);
}

sub nextchar {
    if ($#buffer < $pos) {
	return undef; # eof signal
    }
#    print STDERR "Consider $pos: \"$buffer[$pos]\" ", join(" ",  @stack), "\n";
    return $buffer[$pos];
}

sub eatchar {
    ++ $pos;
}

sub gettextfrom {
    my $first = shift;
    return join("", @buffer[$first..$pos-1]);
}

# rollback for alternative parsing - not 100% nice....
sub mark {
    return $pos;
}
sub rollback {
    $newpos = shift;
    $maxpos = $pos if $pos > $maxpos;
    $maxback = ($pos - $newpos) if ($pos - $newpos) > $maxback;
    $pos = $newpos;
}
# EoF checking
sub EoF {
    return ($pos >= $#buffer);
}

sub error {
    my $str = shift;
    print STDERR $str, "\n";
    # errror handling? what error handling?
}

sub PrintTrailer {
# print whatever got parsed, but rolled back
    print @buffer[$pos..$maxpos], "<*>", @buffer[$maxpos+1..$maxpos+10], "\n";
}

#-------- Debug routines ---------------
sub enter {
    push(@stack, shift);
    return $#stack;
}

sub leave {
    my $level = shift;
    $#stack = $level-1;
}
1;
